<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">Payment Records</h5>
          
          <div class="ms-auto my-auto mt-lg-0 mt-4">
            <label class="text-sm  mt-4">Sort Transaction By Subscrition Type: </label>
                <select class="form-control"  onchange="javascript:location.href = this.value;">
                    <option value="/subscriptions/approved?type=1" <?php echo e((request()->get('type') == '1' ) ? 'selected' : ''); ?> >Approved Payment</option>
                    <option value="/subscriptions/approved?type=2" <?php echo e((request()->get('type') == '2' ) ? 'selected' : ''); ?> >Rejected Payment</option>
                    
            </select>   
            </div>
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          <?php if($errors->get('msgError')): ?>
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              <?php echo e($errors->first()); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <?php if(session('success')): ?>
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              <?php echo e(session('success')); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <table class="table table-flush" id="data-list">
            <thead class="thead-light">
              <tr>
                <th>SELECT</th>
                <th>USER NAME</th>
                <th>SUBSCRIPTION PACKAGE</th>
                <th>TRANSACTION ID</th>
                <th>PAYMENT PROOF</th>
                <th>PAYMENT MODE</th>
                <th>REMARK</th>
                <th>SUBMIT DATE</th>
                <th>UPDATE DATE</th>
                <th>STATUS</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              <?php if(count($data) > 0): ?>
              <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr id="<?php echo e($item->id); ?>">
                <td class="text-sm">
                  <div class="form-check my-auto">
                  <input class="form-check-input sub_chk" type="checkbox" id="customCheck1" data-id="<?php echo e($item->id); ?>" value="<?php echo e($item->id); ?>">
                  </div>
                </td>
                <td class="text-sm"><a href="<?php echo e(url('/user-track/' . $item->user_id)); ?>" target="_blank" class="text-info text-bold"><?php echo e($item->name); ?></a></td>
                <td class="text-sm"><span class="badge bg-primary"><?php echo e($item->modal_info); ?></span></td>
                <td class="text-sm"><?php echo e($item->transaction_id); ?></td>
                <td class="text-sm"><?php echo e($item->payment_modal); ?></td>
                <td class="text-sm"><a href="<?php echo e(url('images/payment/'.$item->image)); ?>" target="_blank"><img class="img-square" width="100" height="200" src="<?php echo e(url('images/payment/'.$item->image)); ?>"/></a></td>
                <td class="text-sm"><?php echo e($item->remark); ?></td>
                <td class="text-sm"><?php echo date('d-M-y H:i:s',strtotime($item->created_at)); ?></td>
                <td class="text-sm"><?php echo date('d-M-y H:i:s',strtotime($item->updated_at)); ?></td>
                 <td class="text-sm" >
                  <?php if($item->status==1): ?>
                  <span class="badge bg-success">Approved</span>
                  <?php elseif($item->status==2): ?>
                  <span class="badge bg-danger">Rejected</span>
                  <?php endif; ?>
                </td>
                <td class="text-sm">
                  <a href="<?php echo e(url('user-track/' . $item->user_id)); ?>"  target="_blank" class="mx-3" data-bs-toggle="tooltip" data-bs-original-title="Track User">
                    <i class="fas fa-chart-line text-info"></i>
                  </a>
                  
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>no content </tr>
              <?php endif; ?>
            </tbody>
          </table>
         
          <?php echo e($data->links('components.paginate')); ?>

        </div>
      </div>
    </div>
  </div>
</div>
<?php echo $__env->make('modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script src="<?php echo e(URL::asset('assets/js/plugins/datatables.js')); ?>"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>
<script src="../../assets/js/plugins/modal.js"></script>
<script>
  if (document.getElementById('data-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#data-list", {
      searchable: true,
      fixedHeight: true,
      perPage: 15,
      labels: {
        placeholder: "Search...",
        perPage: "Show {select} entries",
        noRows: "No entries found",
        info: "Showing <?php echo e($data->firstItem()); ?> to <?php echo e($data->lastItem()); ?> of <?php echo e($data->total()); ?> entries"
      },
    });

    document.querySelectorAll(".export").forEach(function(el) {
      el.addEventListener("click", function(e) {
        var type = el.dataset.type;

        var data = {
          type: type,
          filename: "alias-" + type,
        };

        if (type === "csv") {
          data.columnDelimiter = "|";
        }

        dataTableSearch.export(data);
      });
    });
  };
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);

  });


</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('user_type.auth', ['parentFolder' => '', 'childFolder' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/apkearng/rewardso.apkearngigs.com/resources/views/subscriptions/approved.blade.php ENDPATH**/ ?>