@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])


@section('content')
<style>
    /* HIDE RADIO */
    [type=radio] {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
    }

    /* IMAGE STYLES */
    [type=radio]+img {
        cursor: pointer;
    }

    /* CHECKED STYLES */
    [type=radio]:checked+img {
        outline: 2px solid #f00;
    }
</style>
<main class="main-content mt-1 border-radius-lg">
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-9 mx-auto">
                
                @if($errors->get('msgError'))
                  <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                    <span class="alert-text text-white">
                      {{$errors->first()}}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                  </div>
                  @endif
                  @if(session('success'))
                  <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                    <span class="alert-text text-white">
                      {{ session('success') }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                  </div>
                  @endif
                
                <div class="card card-body mt-4">
                    
                    <h6 class="mb-0">Home Page Category Buttons</h6>
                    <p class="text-sm mb-0">Home Page Category Buttons</p>
                            <hr class="horizontal dark my-3">
                            <form action="/app-setting/homepage/update" method="POST" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="type" value="top">
                                <input type="hidden" name="btn_theme" value="{{$data->btn_theme}}" id="btn_theme">
                                <input type="hidden" name="id" value="{{$data->id}}">
                                <input type="hidden" name="oldicon" value="{{$data->icon}}">
                                
                                <div class="form-group">
                                    <label class="form-label">Select Home Category</label>
                                    <select name="cat" class="form-control" id="cat">
                                        @foreach($cat as $item)
                                        @if($item->cat_type=='task')
                                        <option value="{{$item->id}}" data-value="{{$item->cat_theme}}" {{ ($data->cat == $item->id ) ? 'selected' : '' }}> {{$item->title}} </option>
                                        @endif
                                        @endforeach
                                    </select>
                                </div>
                                

                                <div id="btnstyle0" class="form-group">
                                    <label for="categoryName" class="form-label">Select Button Background Color</label>
                                    <div class="">
                                        <label>
                                            <input type="radio" name="background_color0" value="0" {{ ($data->btn_background == '0' && $data->btn_theme =='0' ) ? 'checked' : '' }}>
                                            <img src="{{URL::asset('assets/img/task/background_style1.png') }}"
                                                class="avatar avatar-xxl shadow" width="100" height="100"
                                                alt="Option 1">
                                            <label>

                                                <label>
                                                    <input type="radio" name="background_color0" value="1" {{ ($data->btn_background == '1' && $data->btn_theme =='0') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/background_style2.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="background_color0" value="2" {{ ($data->btn_background == '2' && $data->btn_theme =='0') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/background_style3.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="background_color0" value="3" {{ ($data->btn_background == '3' && $data->btn_theme =='0') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/background_style4.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="background_color0" value="4" {{ ($data->btn_background == '4' && $data->btn_theme =='0') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/background_style5.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="background_color0" value="5" {{ ($data->btn_background == '5' && $data->btn_theme =='0') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/background_style6.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label id="divcolor">
                                                    <input type="hidden" name="" value="">
                                                    <input type="color" class="form-control"
                                                        name="background_color_code" value="{{$data->background_color}}"
                                                        placeholder="#FFA9A9" style="height:70px; width:70px;">
                                                </label>

                                    </div>
                                </div>

                                <div id="btnstyle1" class="form-group">
                                    <label for="categoryName" class="form-label">Select Background Color</label>
                                    <div class="row">
                                        <div class="col-3 form-group">
                                            <label for="recipient-name" class="form-label">Card Background Color</label>
                                            <input type="color" class="form-control" name="background_color1"
                                                value="{{$data->background_color}}" placeholder="#FFA9A9" style="height:70px; width:70px;">
                                        </div>

                                        <div class="col-3 form-group">
                                            <label for="recipient-name" class="form-label">Button Background
                                                Color</label>
                                            <input type="color" class="form-control" name="btnbackground_color1"
                                                value="{{$data->btn_color}}" placeholder="#FFA9A9" style="height:70px; width:70px;">
                                        </div>
                                    </div>
                                </div>
                             
                                
                                <div id="btnstyle2" class="form-group">
                                    <label for="categoryName" class="form-label">Select Card Background Color</label>
                                    <div class="">
                                        <label>
                                            <input type="radio" name="background_color2" value="0" {{ ($data->btn_background == '0' && $data->btn_theme =='8' || $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                            <img src="{{URL::asset('assets/img/task/bg1.png') }}"
                                                class="avatar avatar-xxl shadow" width="100" height="100"
                                                alt="Option 1">
                                            <label>

                                                <label>
                                                    <input type="radio" name="background_color2" value="1" {{ ($data->btn_background == '1' && $data->btn_theme =='8' || $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg2.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="background_color2" value="2" {{ ($data->btn_background == '2' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg3.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="background_color2" value="3" {{ ($data->btn_background == '3' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg4.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="background_color2" value="4" {{ ($data->btn_background == '4' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg5.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="background_color2" value="5" {{ ($data->btn_background == '5' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg6.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="background_color2" value="6" {{ ($data->btn_background == '6' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg7.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="background_color2" value="7" {{ ($data->btn_background == '7' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg8.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="background_color2" value="8" {{ ($data->btn_background == '8' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg9.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="background_color2" value="9" {{ ($data->btn_background == '9' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg10.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="background_color2" value="10" {{ ($data->btn_background == '10' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/bg11.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>
                        
                                                <label>
                                                    <input type="radio" name="background_color2" value="11" {{ ($data->btn_background == '11' && $data->btn_theme =='8'|| $data->btn_theme =='7' || $data->btn_theme =='2') ? 'checked' : '' }}>
                                                    <img src="{{URL::asset('assets/img/task/background_style6.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label id="divcolor2">
                                                    <input type="hidden" name="" value="">
                                                    <input type="color" class="form-control"
                                                        name="background_color_code2" value="{{$data->background_color}}"
                                                        placeholder="#FFA9A9" style="height:70px; width:70px;">
                                                </label>
                                                
                                                <div id="btnstyle7" class="form-group">
                                                    <div class="row">
                                                        <div class="col-2 form-group">
                                                            <label for="recipient-name" class="form-label">Card Background Color</label>
                                                            <input type="color" class="form-control" name="background_color7"
                                                                value="{{$data->background_color}}" placeholder="#FFA9A9" style="height:70px; width:70px;">
                                                        </div>
                
                                                        <div class="col-2 form-group">
                                                            <label for="recipient-name" class="form-label">Button Background
                                                                Color</label>
                                                            <input type="color" class="form-control" name="btnbackground_color7"
                                                                value="{{$data->background_color}}" placeholder="#FFA9A9" style="height:70px; width:70px;">
                                                        </div>
                                                    </div>
                                                </div>

                                    </div>
                                </div>
                                
                                <div id="btnstyle5" class="form-group">
                                    <label for="categoryName" class="form-label">Select Background Color</label>
                                    <div class="row">
                                        <div class="col-3 form-group">
                                            <label for="recipient-name" class="form-label">Card Background Color</label>
                                            <input type="color" class="form-control" name="background_color5"
                                                value="{{$data->background_color}}" placeholder="#FFA9A9" style="height:70px; width:70px;">
                                        </div>
                                    </div>
                                </div>
   <hr>

                                <div class="form-group">
                                    <label for="categoryName" class="form-label">Button Title</label>
                                    <div class="">
                                        <input type="title" class="form-control " value="{{$data->title}}"
                                            placeholder="Spin Win,Scrath Card" name="title" onfocus="focused(this)"
                                            onfocusout="defocused(this)" required>
                                        @error('name')
                                        <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div id="divsubtitle" class="form-group">
                                    <label for="categoryName" class="form-label">Button Subtitle Title</label>
                                    <div class="">
                                        <input type="text" class="form-control " value="{{$data->subtitle}}"
                                            placeholder="win 500 coin" name="subtitle" onfocus="focused(this)"
                                            onfocusout="defocused(this)" >
                                        @error('subtitle')
                                        <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="categoryName" id="iconLable" class="form-label"> ICON (100*100)</label>
                                    <div class="">
                                        <input type="file" class="form-control " name="icon"
                                            >
                                        @error('icon')
                                        <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div id="divbtnName" class="form-group">
                                    <label for="categoryName" class="form-label">Button Name</label>
                                    <div class="">
                                        <input type="text" class="form-control "  value="{{$data->btn_name}}"
                                            placeholder="Claim,Start,Join,Play etc" name="btn_name"
                                            onfocus="focused(this)" onfocusout="defocused(this)" >
                                        @error('btn_name')
                                        <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label for="categoryName" class="form-label">Button Order</label>
                                    <div class="">
                                        <input type="number" class="form-control"
                                            placeholder="0,1"  value="{{$data->roworder}}" name="roworder" onfocus="focused(this)"
                                            onfocusout="defocused(this)" required>
                                        @error('roworder')
                                        <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group" id="divClick">
                                    <label for="recipient-name" class="form-label">On Button Click to Open
                                        Screen</label>
                                    <select name="btn_action" class="form-control" required>
                                        @foreach($btn as $item)
                                        <option value="{{$item->type}}" {{($data->btn_action == $item->type) ? 'selected' :'' }}>{{$item->title}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group" id="divurl">
                                    <label for="recipient-name" class="form-label">URL (required if On Click select
                                        URL)</label>
                                    <input type="text" class="form-control" name="url" value="{{$data->url}}" placeholder="http://">
                                </div>

                                <div class="d-flex justify-content-end mt-4">
                                    <a href="{{ url('/app-setting/homepage') }}" type="button" name="button"
                                        class="btn btn-light m-0">BACK TO LIST</a>
                                    <button type="submit" name="button" class="btn bg-gradient-primary m-0 ms-2">Update
                                        Button</button>
                                </div>
                            </form>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
@push('js')
<script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>

<script>
    $(document).ready(function () {
        $("#alert-success").delay(3000).slideUp(300);
        $('#divcolor').hide();
        var elem=document.getElementById("cat");
        var id = elem.options[elem.selectedIndex].getAttribute('data-value');
        hidestyle(id);
        
        
    });


    $("input:radio[name=background_color0]").click(function () {
        var val = $('input:radio[name=background_color0]:checked').val();
        if (val == 5) {
            $('#divcolor').show();
        } else {
            $('#divcolor').hide();
        }
    });
    
    $("input:radio[name=background_color2]").click(function () {
        var val = $('input:radio[name=background_color2]:checked').val();
        if (val == 11) {
           var elem=document.getElementById("cat");
           var id = elem.options[elem.selectedIndex].getAttribute('data-value');
            
            if(id==7){
                $('#btnstyle7').show();
                $('#divcolor2').hide();
            }else{
                $('#divcolor2').show();
            }
        } else {
           
            $('#divcolor2').hide();
            $('#btnstyle7').hide();
        }
    });
    
    $('#cat').change(function() {
        var elem=document.getElementById("cat");
        var id = elem.options[elem.selectedIndex].getAttribute('data-value');
        $('#btn_theme').val(id)
        hidestyle(id);
    });

    function hidestyle(val) {
        $('#btnstyle0').hide();
        $('#btnstyle1').hide();
        $('#btnstyle2').hide();
        $('#btnstyle5').hide();
        $('#btnstyle7').hide();

        if (val == 0) {
            $('#btnstyle0').show();
            $('#divsubtitle').hide();
            $('#divbtnName').hide();
        }
        else if (val == 1) {
            $('#btnstyle1').show();
            $('#divsubtitle').show();
            $('#divbtnName').show();
        }
        else if (val == 2) {
            $('#btnstyle2').show();
            $('#divsubtitle').hide();
            $('#divbtnName').hide();
            $('#divcolor2').hide();

        }else if (val == 3) {
            $('#iconLable').text('Icon Size ( width 100 * height 100 )');
            $('#divsubtitle').hide();
            $('#divbtnName').hide();
        }
        else if (val == 4) {
            $('#iconLable').text('Icon Size ( width 200 * height 150 )');
            $('#divsubtitle').hide();
            $('#divbtnName').hide();
        }
        else if (val == 5) {
            $('#iconLable').text('Icon Size ( width 100 * height 100 )');
            $('#btnstyle5').show();
            $('#divsubtitle').hide();
            $('#divbtnName').hide();
        }
        else if (val == 6) {
            $('#iconLable').text('Icon Size ( width 60 * height 60 )');
            $('#btnstyle5').show();
            $('#divsubtitle').hide();
            $('#divbtnName').hide();
        }
        else if (val == 7) {
            $('#iconLable').text('Icon Size ( width 100 * height 100 )');
            $('#btnstyle2').show();
            $('#divsubtitle').show();
            $('#divbtnName').show();
        }else if (val == 8) {
            $('#iconLable').text('Icon Size ( width 100 * height 100 )');
            $('#btnstyle2').show();
            $('#divsubtitle').show();
            $('#divbtnName').show();
        }

    }

</script>
@endpush