<?php

namespace App\Http\Controllers;

use App\Models\_Onboarding;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Image;
use File;
use Carbon\Carbon;

class Onboarding extends Controller
{


    public function index()
    {
        $data = _Onboarding::paginate();
        return view('pages/onboarding', compact('data'));
    }

    public function store(Request $request)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $onboarding = new _Onboarding;
        $onboarding->title = $request->title;
        $onboarding->subtitle = $request->subtitle;
        $onboarding->image = $request->icon;
        $res = $onboarding->save();
        if ($res) {
            return redirect('/app-setting#onboard')->with('success', 'Added Successfully!');
        } else {
            return redirect('/app-setting#onboard')->with('error', 'Technical Error!');
        }
      
    }

    public function edit(_Onboarding $id)
    {
        return $id;
    }

    public function update(Request $request)
    {

        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $onboarding = _Onboarding::find($request->id);
        $onboarding->title = $request->title;
        $onboarding->subtitle = $request->subtitle;
        $onboarding->image = $request->icon;
        $res = $onboarding->save();
        if ($res) {
            return redirect('/app-setting#onboard')->with('success', 'Update Successfully!');
        } else {
            return redirect('/app-setting#onboard')->with('error', 'Technical Error!');
        }
       
    }

    public function destroy($id)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        $banner = _Onboarding::where('id', $id)->get()->first()->image;
        $image_path = "/images/" . $banner;
        if (File::exists($image_path)) {
            File::delete($image_path);
        }
        _Onboarding::find($id)->delete();
        return 1;
    }

    public function action(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = _Onboarding::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = _Onboarding::whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }
    
}