<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\_Home;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use App\Models\AppOffer;
use App\Models\Recharge;
use App\Models\Video;
use App\Models\Web;
use Illuminate\Support\Facades\Validator;

class Home extends Controller
{
    public function index()
    {
        $user=  Users::count();   
        $ban=  Users::where('status',1)->count();   
        $today=  Users::whereDate('inserted_at',date('Y-m-d'))->count();   
        $appopen=  Users::whereDate('updated_at',date('Y-m-d'))->count();   
        $apps=  AppOffer::where('status',0)->count();   
        $redeem=  DB::table('redeem')->count();   
        $trans=  DB::table('transaction')->count();   
        $video=  Video::where('status',0)->count();   
        $weblink=  Web::where('status',0)->count();   
        $pending=DB::table('recharge_request')->where('status','Pending')->count();
        $complete=DB::table('recharge_request')->where('status','Success')->count();
        $sdk=DB::table('offerwall')->where('type','sdk')->count();
        $web=DB::table('offerwall')->where('type','web')->count();
        $api=DB::table('offerwall')->where('type','api')->count();
        $doffer=DB::table('tbl_dailyoffer')->count();
        $store=DB::table('coinstore')->count();
        $game=DB::table('games')->count();
        $month=Users::whereMonth('inserted_at', date('m'))
        ->whereYear('inserted_at', date('Y'))
        ->count();
        
           return view('dashboards.default',
                ['user'=>$user,
                'apps'=>$apps,
                'redeem'=>$redeem,
                'video'=>$video,
                'weblink'=>$weblink,
                'pending'=>$pending,
                'trans'=>$trans,
                'complete'=>$complete,
                'sdk'=>$sdk,
                'web'=>$web,
                'api'=>$api,
                'doffer'=>$doffer,
                'store'=>$store,
                'game'=>$game,
                'appopen'=>$appopen,
                'today'=>$today,
                'ban'=>$ban,
                'month'=>$month,
                ]);
    }
    
    public function indexAppHome(){
        if(isset(request()->type) && request()->type>0){
              $data = DB::table('home')->
                join('home_category','home_category.id','=','home.cat')
                ->where('cat',request()->type)
                ->select('home.*','home_category.title as cattitle')
                ->orderBy('roworder','ASC')->paginate();
        }else{
            $data = DB::table('home')->
            join('home_category','home_category.id','=','home.cat')
            ->select('home.*','home_category.title as cattitle')
            ->orderBy('roworder','ASC')->paginate();
        }       
        $cat=DB::table('home_category')->where('cat_type','task')->orderBy('row_order','ASC')->get();
        return view('home/hometask',['data'=>$data,'cat'=>$cat]);
    }
    
    public function indexCatHome(){
       $data=DB::table('home_category')->orderBy('row_order','ASC')->paginate(15);
       return view('home/category',['data'=>$data]);    
    }
    
    public function AddCatHome(){
      return view('home/add-category');    
    }
    
    public function AddHome(){
        $data=DB::table('home_category')->orderBy('row_order','ASC')->get();
        $btn=DB::table('btn_action')->where('cat','btn')->orderBy('row_order','ASC')->get();
      return view('home/add-top',['cat'=>$data,'btn'=>$btn]);    
    }
    
    public function EditHome(_Home $id){
       $cat=DB::table('home_category')->orderBy('row_order','ASC')->get(); 
        $btn=DB::table('btn_action')->where('cat','btn')->orderBy('row_order','ASC')->get();
        return view('home/edit-top',['data'=>$id,'cat'=>$cat,'btn'=>$btn]);
    }
    
    public function EditCatHome($id){
        return view('home/edit-category',['data'=>DB::table('home_category')->where('id',$id)->get()]);
    }
    
    public function DeleteCatHome($id){
        
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        DB::table('home_category')->where('id',$id)->delete();
        DB::table('home')->where('cat',$id)->delete();
        return 1;
    }
    
    public function DeleteHome($id){
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        DB::table('home')->where('id',$id)->delete();
        return 1;
    }
    
    public function StoreHome(Request $req){
        
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        
        if($req->type=='category'){
            $res=DB::table('home_category')->insert([
                'title'=>$req->title,
                'cat_theme'=>$req->cat_theme,
                'view_mode'=>$req->view_mode,
                'row_order'=>$req->row_order
                ]);
                
                
             if($res){
                return redirect('/app-setting/homepage/category')->with('success', 'Category Added Successfully');
            }else{
                 return redirect('/app-setting/homepage/category')->with('error', 'Something went wrong');
            }
        }
        
        if($req->icon){
          $filename=  Fun::StoreImage("image",null,null,$req,"icon",false);
          if($filename==null){
             return redirect('/app-setting/homepage/create')->with('error', 'Technical Error in Image Upload');
          }
        }
        
        
        $home=new _Home;
        $home->title=$req->title;
        $home->subtitle=(isset($req->subtitle)) ? $req->subtitle : null;
        $home->icon=$filename;
        $home->btn_name=(isset($req->btn_name)) ? $req->btn_name : null;
        $home->btn_action=$req->btn_action;
        $home->url=(isset($req->url)) ? $req->url : null;
        $home->btn_theme=$req->btn_theme;
        $home->cat=$req->cat;
        
        if($req->btn_theme==0){
            $btnbackground=$req->background_color0;
             $home->btn_background=$btnbackground;
            if($btnbackground==5){
              $home->background_color=$req->background_color_code;
            }
        }
        else if($req->btn_theme==1){
           $home->background_color=$req->background_color1;
           $home->btn_color=$req->btnbackground_color1;
        }
        else if($req->btn_theme==2){
            $btnbackground=$req->background_color2;
            $home->btn_background=$btnbackground;
            $home->btn_color=$req->btnbackground_color2;
            if($btnbackground==11){
              $home->background_color=$req->background_color_code2;
            }
        }
        else if($req->btn_theme==5){
            $home->background_color=$req->background_color5;
        }
        else if($req->btn_theme==6){
            $home->background_color=$req->background_color5;
        }
        else if($req->btn_theme==7  || $req->btn_theme==8){
            $btnbackground=$req->background_color2;
            $home->btn_background=$btnbackground;
            if($btnbackground==11){
              $home->background_color=$req->background_color7;
              $home->btn_color=$req->btnbackground_color7;
            }
        }
      
        $home->roworder=$req->roworder;
        $home->type=$req->type;
        $res=$home->save();
        
        if($res){
             return redirect('/app-setting/homepage')->with('success', 'Button Added Successfully');
            
        }else{
             return redirect('/app-setting/homepage/create')->with('error', 'Something went wrong');
        }
        
    }
    
    public function UpdateHome(Request $req){
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

       
        if($req->type=='category'){
            $res=DB::table('home_category')->where('id',$req->id)->update([
                'title'=>$req->title,
                'cat_theme'=>$req->cat_theme,
                'view_mode'=>$req->view_mode,
                'row_order'=>$req->row_order
                ]);
                
               _Home::where('cat',$req->id)->update(['btn_theme'=>$req->cat_theme]); 
             if($res){
                return redirect('/app-setting/homepage/category')->with('success', 'Category Update Successfully');
            }else{
                 return redirect('/app-setting/homepage/category')->with('error', 'Something went wrong');
            }
        }
        
        if($req->icon){
          $filename=  Fun::StoreImage("image",null,null,$req,"icon",true);
          if($filename==null){
             return redirect('/app-setting/homepage/create')->with('error', 'Technical Error in Image Upload');
          }
        }else{
           $filename=$req->oldicon; 
        }
        
        $btnTheme=DB::table('home_category')->where('id',$req->cat)->first();
        
        $home=_Home::find($req->id);
        $home->title=$req->title;
        $home->subtitle=(isset($req->subtitle)) ? $req->subtitle : null;
        $home->icon=$filename;
        $home->btn_name=(isset($req->btn_name)) ? $req->btn_name : null;
        $home->btn_action=$req->btn_action;
        $home->url=(isset($req->url)) ? $req->url : null;
        $home->btn_theme=$btnTheme->cat_theme;
        $home->cat=$req->cat;
        
        if($btnTheme->cat_theme==0){
            $btnbackground=$req->background_color0;
            $home->btn_background=$btnbackground;
            if($btnbackground==5){
              $home->background_color=$req->background_color_code;
            }
        }
        else if($btnTheme->cat_theme==1){
           $home->background_color=$req->background_color1;
           $home->btn_color=$req->btnbackground_color1;
        }
        else if($btnTheme->cat_theme==2){
            $btnbackground=$req->background_color2;
            $home->btn_background=$btnbackground;
            $home->btn_color=$req->btnbackground_color2;
            if($btnbackground==11){
              $home->background_color=$req->background_color_code2;
            }
        }
        else if($btnTheme->cat_theme==5){
            $home->background_color=$req->background_color5;
        }
        else if($btnTheme->cat_theme==6){
            $home->background_color=$req->background_color5;
        }
        else if($btnTheme->cat_theme==7  || $btnTheme->cat_theme==8){
            $btnbackground=$req->background_color2;
            $home->btn_background=$btnbackground;
            if($btnbackground==11){
              $home->background_color=$req->background_color7;
              $home->btn_color=$req->btnbackground_color7;
            }
        }
      
        $home->roworder=$req->roworder;
        $home->type=$req->type;
        $res=$home->save();
        
        if($res){
             return redirect('/app-setting/homepage')->with('success', 'Button Update Successfully');
            
        }else{
             return redirect('/app-setting/homepage/create')->with('error', 'Something went wrong');
        }
        
    }
    
    public function CatHomeAction(Request $req){
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = DB::table('home_category')->whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = DB::table('home_category')->whereIn('id', explode(",", $req->id))->update(['status' => 2]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }  
    }
    
    public function HomeAction(Request $req)
    {   
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }


        if ($req->status == "enable") {
            $update = _Home::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = _Home::whereIn('id', explode(",", $req->id))->update(['status' => 2]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }
    
}