<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Alias;
use Illuminate\Support\Facades\DB;
use Exception;

class Alias_ extends Controller
{
    public function index()
    {
        $data=Alias::fastPaginate();
        return view('pages/alias', compact('data'));
    }


    public function store(Request $request)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $attributes = request()->validate([
            'tag' => ['required'],
            'description' => ['required'],
        ]); 
        Alias::create(['tag' => $attributes['tag'], 'description'=> $attributes['description'], 'created_at' => now()]);
       
        return redirect('/alias-management')->with('success','Alias successfully added.');
    }

    public function edit(Request $request)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

         $attributes = request()->validate([
            'id' => ['required'],
            'description' => ['required'],
        ]);         
        Alias::where('id',$attributes['id'])->update(['description'=> $attributes['description']]);
        return redirect('/alias-management')->with('success','Alias successfully Updated.');
    }

}
