<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\_Ads;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use File,Image;
use Illuminate\Support\Facades\Validator;

class Ads extends Controller
{
    public function indexNative()
    {
        $data = _Ads::paginate();
        return view('admin-setting/ads/native-ad', compact('data'));
    }
    
    public function editNative(_Ads $id)
    {
        return view('admin-setting/ads/edit-native',['data'=>$id]);
    }
    
    public function createNative()
    {
        return view('admin-setting/ads/add-native');
    }


    public function indexAds()
    {
        $data = DB::table('tbl_setting')->where('id', 1)->get();
        $inter = json_decode($data[0]->interstitalID);
        return view('admin-setting/ads/ads', ['data' => $data, 'inter' => $inter]);
    }
    
    public function storeNative(Request $req){
        
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        
        $validator = Validator::make($req->all(), [
            'title' => ['required'],
            'description' => ['required'],
            'icon' => ['required'],
            'image' => ['required'],
            'btn_name' => ['required'],
            'url' => ['required'],
        ]);
        
        if($validator->fails()){
            return back()->withErrors($validator->errors())->withInput();
        }
        
        $image = $req->icon;
        $extension = $image->getClientOriginalExtension();
        $fileNameToStore = uniqid() . '_' . time() . '.' . $extension;
        $image_resize = Image::make($image->getRealPath());
        $image_resize->resize(100, 100);
        $image_resize->save('images/' . $fileNameToStore);
        
        $file = $req->file('image');
         $thumb = uniqid().time().'.'.$file->getClientOriginalExtension();
         $location = public_path('images/');
         $file->move($location,$thumb); 
        
        $ad= new _Ads;
        $ad->title=$req->title;
        $ad->description=$req->description;
        $ad->icon=$fileNameToStore;
        $ad->image=$thumb;
        $ad->btn_name=$req->btn_name;
        $ad->url=$req->url;
        $res=$ad->save();
        
        if($res){
              return redirect('/ads/native')->with('success', 'Native Ad Added Successfully!');
        }else{
            return redirect('/ads/native')->with('error', 'Something went wrong!');
        }
    }
    
    public function updateNative(Request $req){
        
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $validator = Validator::make($req->all(), [
            'title' => ['required'],
            'description' => ['required'],
            'oldicon' => ['required'],
            'oldimage' => ['required'],
            'btn_name' => ['required'],
            'url' => ['required'],
        ]);
        
        if($validator->fails()){
            return back()->withErrors($validator->errors())->withInput();
        }
        
        if($req->icon){
            $image = $req->icon;
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = uniqid() . '_' . time() . '.' . $extension;
            $image_resize = Image::make($image->getRealPath());
            $image_resize->resize(100, 100);
            $image_resize->save('images/' . $fileNameToStore);
            $icon=$fileNameToStore;
             $image_path = "/images/" . $req->oldicon;
            if (File::exists($image_path)) {
                File::delete($image_path);
            }
        }else{
         $fileNameToStore=$req->oldicon; 
        }
        
        if($req->file('image')){
            $file = $req->file('image');
             $thumb = uniqid().time(). '.' . $file->getClientOriginalExtension();
             $location = public_path('images/');
             $file->move($location,$thumb); 
             
            $image_path = "/images/" . $req->oldimage;
            if (File::exists($image_path)) {
                File::delete($image_path);
            }
        }else{
            $thumb=$req->oldimage;
        }
        
        $ad= _Ads::find($req->id);
        $ad->title=$req->title;
        $ad->description=$req->description;
        $ad->icon=$fileNameToStore;
        $ad->image=$thumb;
        $ad->btn_name=$req->btn_name;
        $ad->url=$req->url;
        $res=$ad->save();
        
        if($res){
              return redirect('/ads/native')->with('success', 'Native Ad Update Successfully!');
        }else{
            return redirect('/ads/native')->with('error', 'Something went wrong!');
        }
    }

    

    public function update(Request $req)
    {
       
       if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        
        $data = DB::table('tbl_setting')->where('id', 1)->get();
        $inter = json_decode($data[0]->interstitalID);

        $interstitaliD = array([
            'au_admob' => $inter[0]->au_admob,
            'au_applovin' => $inter[0]->au_applovin,
            'au_unity' => $inter[0]->au_unity,
            'au_fb' => $inter[0]->au_fb,
            'au_admobR' => $req->au_admobR,
            'au_fbR' => $req->au_fbR,
            'au_unityR' => $req->au_unityR,
            'au_charboostR' => $req->au_charboostR,
            'chartboostSignature' => $req->chartboostSignature,
            'au_vungleR' => $req->au_vungleR,
            'au_applovinR' => $req->au_applovinR,
            'vungleAppid' => $req->vungleAppid,
            'chartboostAppid' => $req->chartboostAppid,
            'isApplovin' => ($req->isApplovin == "on") ? 'true' : 'false',
            'isAdmob' => ($req->isAdmob == "on") ? 'true' : 'false',
            'isUnity' => ($req->isUnity == "on") ? 'true' : 'false',
            'isStart' => ($req->isStart == "on") ? 'true' : 'false',
            'isAdcolony' => ($req->isAdcolony == "on") ? 'true' : 'false',
            'isFb' => ($req->isFb == "on") ? 'true' : 'false',
            'isVungle' => ($req->isVungle == "on") ? 'true' : 'false',
            'isChartboost' => ($req->isChartboost == "on") ? 'true' : 'false'
        ]);

        DB::table('tbl_setting')->where('id', 1)->update([
            'startapp_appid' => $req->startapp_appid,
            'unity_game' => $req->unity_game,
            'interstital_adunit' => $req->interstital_adunit,
            'adcolonyApp' => $req->adcolonyApp,
            'adcolony_zone' => $req->adcolony_zone,
            'banner_type' => $req->banner_type,
            'bannerID' => $req->bannerID,
            'interstital_type' => $req->interstital_type,
            'interstital_count' => $req->interstitalCount,
            'nativeType' => $req->native_type,
            'nativeID' => $req->nativeID,
            'native_count' => $req->nativeCount,
            'interstitalID' => json_encode($interstitaliD),
        ]);

        return redirect('/ads/setting')->with('success', 'Update Successfully!');
       
    }
    
    public function deleteNative($id){
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        $ad =_Ads::find($id);
        
        $image_path = "/images/" . $ad->icon;
        if (File::exists($image_path)) {
            File::delete($image_path);
        }
        
        $image_path = "/images/" . $ad->image;
        if (File::exists($image_path)) {
            File::delete($image_path);
        }
        
        return 1;
        
    }
    
    public function action(Request $req){
        
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

         if($req->status=="enable"){
            $update =_Ads::whereIn('id',explode(",",$req->id))->update(['status'=>0]); 
            if($update){
                return 1;
            }else{
                return "not updated";
            }
        }
        else if($req->status=="disable"){
            $update =_Ads::whereIn('id',explode(",",$req->id))->update(['status'=>1]); 
            if($update){
                return 1;
            }else{
                return "not updated";
            }
        }
    }

    public static function updateData($key, $value)
    {
        $path = base_path('.env');

        if (file_exists($path)) {

            file_put_contents($path, str_replace(
                $key . '=' . env($key),
                $key . '=' . $value,
                file_get_contents($path)
            ));
        }
    }
}
